/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.compiler;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import org.apache.maven.api.JavaPathType;

final class WorkaroundForPatchModule
extends ForwardingJavaFileManager<StandardJavaFileManager>
implements StandardJavaFileManager {
    static final boolean ENABLED = true;
    private final Set<JavaFileManager.Location> definedLocations = new HashSet<JavaFileManager.Location>();
    private final Map<String, Collection<? extends Path>> patchesAsOption = new HashMap<String, Collection<? extends Path>>();
    private boolean needsNewFileManager;

    WorkaroundForPatchModule(StandardJavaFileManager fileManager) {
        super(fileManager);
    }

    StandardJavaFileManager getFileManagerIfUsable() {
        return this.needsNewFileManager ? null : (StandardJavaFileManager)this.fileManager;
    }

    void copyTo(StandardJavaFileManager target) throws IOException {
        for (JavaFileManager.Location location : this.definedLocations) {
            target.setLocation(location, ((StandardJavaFileManager)this.fileManager).getLocation(location));
        }
        for (Map.Entry entry : this.patchesAsOption.entrySet()) {
            Collection paths = (Collection)entry.getValue();
            String moduleName = (String)entry.getKey();
            try {
                target.setLocationForModule(StandardLocation.PATCH_MODULE_PATH, moduleName, paths);
            }
            catch (UnsupportedOperationException e) {
                WorkaroundForPatchModule.specifyAsOption(target, JavaPathType.patchModule((String)moduleName), paths, e);
            }
        }
    }

    private static void specifyAsOption(StandardJavaFileManager fileManager, JavaPathType.Modular type, Collection<? extends Path> paths, UnsupportedOperationException cause) throws IOException {
        String message;
        Iterator<String> it = Arrays.asList(type.option(paths)).iterator();
        if (!fileManager.handleOption(it.next(), it)) {
            message = "Failed to set the %s option for module %s";
        } else if (it.hasNext()) {
            message = "Unexpected number of arguments after the %s option for module %s";
        } else {
            return;
        }
        JavaPathType rawType = type.rawType();
        throw new IllegalArgumentException(String.format(message, rawType.option().orElse(rawType.name()), type.moduleName()), cause);
    }

    @Override
    public void setLocationForModule(JavaFileManager.Location location, String moduleName, Collection<? extends Path> paths) throws IOException {
        boolean isPatch;
        if (paths.isEmpty()) {
            return;
        }
        boolean bl = isPatch = location == StandardLocation.PATCH_MODULE_PATH;
        if (isPatch && this.patchesAsOption.replace(moduleName, paths) != null) {
            this.needsNewFileManager = true;
            return;
        }
        try {
            ((StandardJavaFileManager)this.fileManager).setLocationForModule(location, moduleName, paths);
        }
        catch (UnsupportedOperationException e) {
            if (isPatch) {
                WorkaroundForPatchModule.specifyAsOption((StandardJavaFileManager)this.fileManager, JavaPathType.patchModule((String)moduleName), paths, e);
                this.patchesAsOption.put(moduleName, paths);
                return;
            }
            throw e;
        }
        this.definedLocations.add(((StandardJavaFileManager)this.fileManager).getLocationForModule(location, moduleName));
    }

    @Override
    public void setLocationFromPaths(JavaFileManager.Location location, Collection<? extends Path> paths) throws IOException {
        ((StandardJavaFileManager)this.fileManager).setLocationFromPaths(location, paths);
        this.definedLocations.add(location);
    }

    @Override
    public void setLocation(JavaFileManager.Location location, Iterable<? extends File> files) throws IOException {
        ((StandardJavaFileManager)this.fileManager).setLocation(location, files);
        this.definedLocations.add(location);
    }

    @Override
    public Iterable<? extends File> getLocation(JavaFileManager.Location location) {
        return ((StandardJavaFileManager)this.fileManager).getLocation(location);
    }

    @Override
    public Iterable<? extends Path> getLocationAsPaths(JavaFileManager.Location location) {
        return ((StandardJavaFileManager)this.fileManager).getLocationAsPaths(location);
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjects(String ... names) {
        return ((StandardJavaFileManager)this.fileManager).getJavaFileObjects(names);
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjects(File ... files) {
        return ((StandardJavaFileManager)this.fileManager).getJavaFileObjects(files);
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjects(Path ... paths) {
        return ((StandardJavaFileManager)this.fileManager).getJavaFileObjects(paths);
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjectsFromStrings(Iterable<String> names) {
        return ((StandardJavaFileManager)this.fileManager).getJavaFileObjectsFromStrings(names);
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjectsFromFiles(Iterable<? extends File> files) {
        return ((StandardJavaFileManager)this.fileManager).getJavaFileObjectsFromFiles(files);
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjectsFromPaths(Collection<? extends Path> paths) {
        return ((StandardJavaFileManager)this.fileManager).getJavaFileObjectsFromPaths(paths);
    }

    @Override
    public Path asPath(FileObject file) {
        return ((StandardJavaFileManager)this.fileManager).asPath(file);
    }
}

