/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.policy;

import com.deepoove.poi.data.NumberingRenderData;
import com.deepoove.poi.data.PictureRenderData;
import com.deepoove.poi.data.TableRenderData;
import com.deepoove.poi.data.TextRenderData;
import com.deepoove.poi.policy.AbstractRenderPolicy;
import com.deepoove.poi.policy.NumberingRenderPolicy;
import com.deepoove.poi.policy.PictureRenderPolicy;
import com.deepoove.poi.policy.TableRenderPolicy;
import com.deepoove.poi.policy.TextRenderPolicy;
import com.deepoove.poi.render.RenderContext;
import com.deepoove.poi.util.StyleUtils;
import com.deepoove.poi.xwpf.BodyContainer;
import com.deepoove.poi.xwpf.BodyContainerFactory;
import java.util.List;
import org.apache.poi.xwpf.usermodel.XWPFRun;

public class ListRenderPolicy
extends AbstractRenderPolicy<List<Object>> {
    @Override
    protected boolean validate(List<Object> data) {
        return null != data && !data.isEmpty();
    }

    @Override
    public void doRender(RenderContext<List<Object>> context) throws Exception {
        XWPFRun run = context.getRun();
        BodyContainer bodyContainer = BodyContainerFactory.getBodyContainer(run);
        List<Object> datas = context.getData();
        for (Object data : datas) {
            if (data instanceof TextRenderData) {
                XWPFRun createRun = bodyContainer.insertNewParagraph(run).createRun();
                StyleUtils.styleRun(createRun, run);
                TextRenderPolicy.Helper.renderTextRun(createRun, data);
                continue;
            }
            if (data instanceof TableRenderData) {
                TableRenderPolicy.Helper.renderTable(run, (TableRenderData)data);
                continue;
            }
            if (data instanceof NumberingRenderData) {
                NumberingRenderPolicy.Helper.renderNumbering(run, (NumberingRenderData)data);
                continue;
            }
            if (!(data instanceof PictureRenderData)) continue;
            PictureRenderPolicy.Helper.renderPicture(bodyContainer.insertNewParagraph(run).createRun(), (PictureRenderData)data);
        }
    }

    @Override
    protected void afterRender(RenderContext<List<Object>> context) {
        this.clearPlaceholder(context, true);
    }
}

