// Copyright (c) 1998 by W3C
//
// DOM is a trademark of W3C
// The DOM level 1 specification, from which this
// source is derived, is copyright by W3C.
// See: http://www.w3.org/TR/REC-DOM-Level-1/
//

package org.w3c.dom;

/**
<P>The <A HREF='NodeList.html'><CODE>NodeList</CODE></A> interface provides the abstraction of an
      ordered collection of nodes, without defining or
      constraining how this collection is implemented.
<P>The items in the <A HREF='NodeList.html'><CODE>NodeList</CODE></A> are accessible via an
      integral index, starting from 0.
    

<HR>

<!-- ======== PROPERTY SUMMARY ======== -->

<A NAME="property_summary"><!-- --></A>
<TABLE BORDER=1 CELLPADDING=3 CELLSPACING=0 WIDTH=100%>
<TR BGCOLOR=#CCCCFF ID=TableHeadingColor>
<TD COLSPAN=3><FONT SIZE=+2><B>Property Summary</B>
</FONT></TD></TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-length><CODE>&nbsp;length</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getLength()'>getLength</a>
</TD>
<TD><P>The number of nodes in the list. The range of valid child node
	indices is 0 to <code>length-1</code> inclusive. 
</TD>
</TR>
</TABLE>
&nbsp;
*/
public interface NodeList
{
/**
<P>Returns the <code>index</code>th item in the collection.
	If <code>index</code> is greater than or equal to the number
	of nodes in the list, this returns <code>null</code>.

@return The node at the <code>index</code>th position in the
	  <A HREF='NodeList.html'><CODE>NodeList</CODE></A>, or <code>null</code> if that is not a
	  valid index.
@param index
Index into the collection.
*/
Node item (int index);

	/**
	 * Returns the value of the <code><a href=#att-length>length</a></code> property.
	*/
	int getLength ();


}
