// Copyright (c) 1998 by W3C
//
// DOM is a trademark of W3C
// The DOM level 1 specification, from which this
// source is derived, is copyright by W3C.
// See: http://www.w3.org/TR/REC-DOM-Level-1/
//

package org.w3c.dom.html;

import org.w3c.dom.*;

/**

  <P>The anchor element. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/links.html#edef-A">A element definition</A>
 in HTML 4.0.
  
</P>

<HR>

<!-- ======== PROPERTY SUMMARY ======== -->

<A NAME="property_summary"><!-- --></A>
<TABLE BORDER=1 CELLPADDING=3 CELLSPACING=0 WIDTH=100%>
<TR BGCOLOR=#CCCCFF ID=TableHeadingColor>
<TD COLSPAN=3><FONT SIZE=+2><B>Property Summary</B>
</FONT></TD></TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-accessKey><CODE>&nbsp;accessKey</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getAccessKey()'>getAccessKey</a>
<a href='#setAccessKey(java.lang.String)'>setAccessKey</a>
</TD>
<TD>
  <P>A single character access key to give access to the form control. See the 
    <A  href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-accesskey">accesskey attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-charset><CODE>&nbsp;charset</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getCharset()'>getCharset</a>
<a href='#setCharset(java.lang.String)'>setCharset</a>
</TD>
<TD>
  <P>The character encoding of the linked resource. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/links.html#adef-charset">charset attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-coords><CODE>&nbsp;coords</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getCoords()'>getCoords</a>
<a href='#setCoords(java.lang.String)'>setCoords</a>
</TD>
<TD>
  <P>Comma-separated list of lengths, defining an active region geometry. See also 
    <code>shape</code> for the shape of the region. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/objects.html#adef-coords">coords attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-href><CODE>&nbsp;href</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getHref()'>getHref</a>
<a href='#setHref(java.lang.String)'>setHref</a>
</TD>
<TD>
  <P>The URI of the linked resource. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/links.html#adef-href">href attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-hreflang><CODE>&nbsp;hreflang</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getHreflang()'>getHreflang</a>
<a href='#setHreflang(java.lang.String)'>setHreflang</a>
</TD>
<TD>
  <P>Language code of the linked resource. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/links.html#adef-hreflang">hreflang attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-name><CODE>&nbsp;name</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getName()'>getName</a>
<a href='#setName(java.lang.String)'>setName</a>
</TD>
<TD>
  <P>Anchor name. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/links.html#adef-name-A">name attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-rel><CODE>&nbsp;rel</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getRel()'>getRel</a>
<a href='#setRel(java.lang.String)'>setRel</a>
</TD>
<TD>
  <P>Forward link type. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/links.html#adef-rel">rel attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-rev><CODE>&nbsp;rev</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getRev()'>getRev</a>
<a href='#setRev(java.lang.String)'>setRev</a>
</TD>
<TD>
  <P>Reverse link type. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/links.html#adef-rev">rev attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-shape><CODE>&nbsp;shape</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getShape()'>getShape</a>
<a href='#setShape(java.lang.String)'>setShape</a>
</TD>
<TD>
  <P>The shape of the active area. The coordinates are given by 
    <code>coords</code>. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/objects.html#adef-shape">shape attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-tabIndex><CODE>&nbsp;tabIndex</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getTabIndex()'>getTabIndex</a>
<a href='#setTabIndex(java.lang.String)'>setTabIndex</a>
</TD>
<TD>
  <P>Index that represents the element's position in the tabbing order. See the 
    <A  href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-tabindex">tabindex attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-target><CODE>&nbsp;target</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getTarget()'>getTarget</a>
<a href='#setTarget(java.lang.String)'>setTarget</a>
</TD>
<TD>
  <P>Frame to render the resource in. See the 
    <A  href="http://www.w3.org/TR/REC-html40/present/frames.html#adef-target">target attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-type><CODE>&nbsp;type</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getType()'>getType</a>
<a href='#setType(java.lang.String)'>setType</a>
</TD>
<TD>
  <P>Advisory content type. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/links.html#adef-type-A">type attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
</TABLE>
&nbsp;
*/
public interface HTMLAnchorElement
extends HTMLElement
{
	/** Assigns the value of the <code><a href=#att-accessKey>accessKey</a></code> property.
	 */
	void setAccessKey (String accessKey);

	/**
	 * Returns the value of the <code><a href=#att-accessKey>accessKey</a></code> property.
	*/
	String getAccessKey ();


	/** Assigns the value of the <code><a href=#att-charset>charset</a></code> property.
	 */
	void setCharset (String charset);

	/**
	 * Returns the value of the <code><a href=#att-charset>charset</a></code> property.
	*/
	String getCharset ();


	/** Assigns the value of the <code><a href=#att-coords>coords</a></code> property.
	 */
	void setCoords (String coords);

	/**
	 * Returns the value of the <code><a href=#att-coords>coords</a></code> property.
	*/
	String getCoords ();


	/** Assigns the value of the <code><a href=#att-href>href</a></code> property.
	 */
	void setHref (String href);

	/**
	 * Returns the value of the <code><a href=#att-href>href</a></code> property.
	*/
	String getHref ();


	/** Assigns the value of the <code><a href=#att-hreflang>hreflang</a></code> property.
	 */
	void setHreflang (String hreflang);

	/**
	 * Returns the value of the <code><a href=#att-hreflang>hreflang</a></code> property.
	*/
	String getHreflang ();


	/** Assigns the value of the <code><a href=#att-name>name</a></code> property.
	 */
	void setName (String name);

	/**
	 * Returns the value of the <code><a href=#att-name>name</a></code> property.
	*/
	String getName ();


	/** Assigns the value of the <code><a href=#att-rel>rel</a></code> property.
	 */
	void setRel (String rel);

	/**
	 * Returns the value of the <code><a href=#att-rel>rel</a></code> property.
	*/
	String getRel ();


	/** Assigns the value of the <code><a href=#att-rev>rev</a></code> property.
	 */
	void setRev (String rev);

	/**
	 * Returns the value of the <code><a href=#att-rev>rev</a></code> property.
	*/
	String getRev ();


	/** Assigns the value of the <code><a href=#att-shape>shape</a></code> property.
	 */
	void setShape (String shape);

	/**
	 * Returns the value of the <code><a href=#att-shape>shape</a></code> property.
	*/
	String getShape ();


	/** Assigns the value of the <code><a href=#att-tabIndex>tabIndex</a></code> property.
	 */
	void setTabIndex (int tabIndex);

	/**
	 * Returns the value of the <code><a href=#att-tabIndex>tabIndex</a></code> property.
	*/
	int getTabIndex ();


	/** Assigns the value of the <code><a href=#att-target>target</a></code> property.
	 */
	void setTarget (String target);

	/**
	 * Returns the value of the <code><a href=#att-target>target</a></code> property.
	*/
	String getTarget ();


	/** Assigns the value of the <code><a href=#att-type>type</a></code> property.
	 */
	void setType (String type);

	/**
	 * Returns the value of the <code><a href=#att-type>type</a></code> property.
	*/
	String getType ();


/**

  <P>Removes keyboard focus from this element.
</P>

*/
void blur ();

/**

  <P>Gives keyboard focus to this element.
</P>

*/
void focus ();

}
