package darabonba.core.internal.async;

import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class NoopSubscription implements Subscription {
    private final Subscriber<?> subscriber;

    public NoopSubscription(Subscriber<?> subscriber) {
        this.subscriber = subscriber;
    }

    @Override
    public void request(long l) {
        if (l < 1) {
            subscriber.onError(new IllegalArgumentException("Demand must be positive!"));
        }
    }

    @Override
    public void cancel() {
    }
}

