package darabonba.core.policy.retry.backoff;

import darabonba.core.policy.retry.RetryPolicyContext;
import java.time.Duration;
import static com.aliyun.core.utils.Validate.isNotNegative;


public final class FixedDelayBackoffStrategy implements BackoffStrategy {

    private final Duration fixedBackoff;

    private FixedDelayBackoffStrategy(Duration fixedBackoff) {
        this.fixedBackoff = isNotNegative(fixedBackoff, "fixedBackoff");
    }

    @Override
    public Duration computeDelayBeforeNextRetry(RetryPolicyContext context) {
        return fixedBackoff;
    }

    public static FixedDelayBackoffStrategy create(Duration fixedBackoff) {
        return new FixedDelayBackoffStrategy(fixedBackoff);
    }
}
