/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.render.processor;

import com.deepoove.poi.XWPFTemplate;
import com.deepoove.poi.render.compute.RenderDataCompute;
import com.deepoove.poi.render.processor.AbstractIterableProcessor;
import com.deepoove.poi.render.processor.DrawingSupport;
import com.deepoove.poi.render.processor.IterableContext;
import com.deepoove.poi.render.processor.NumberingContinue;
import com.deepoove.poi.resolver.Resolver;
import com.deepoove.poi.template.IterableTemplate;
import com.deepoove.poi.template.MetaTemplate;
import com.deepoove.poi.xwpf.BodyContainer;
import com.deepoove.poi.xwpf.ParentContext;
import com.deepoove.poi.xwpf.XWPFParagraphWrapper;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.xwpf.usermodel.BodyElementType;
import org.apache.poi.xwpf.usermodel.IBodyElement;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTbl;

public class IterableProcessor
extends AbstractIterableProcessor {
    public IterableProcessor(XWPFTemplate template, Resolver resolver, RenderDataCompute renderDataCompute) {
        super(template, resolver, renderDataCompute);
    }

    @Override
    public void visit(IterableTemplate iterableTemplate) {
        this.logger.info("Process iterableTemplate:{}", (Object)iterableTemplate);
        super.visit(iterableTemplate);
    }

    @Override
    protected void handleNever(IterableTemplate iterableTemplate, BodyContainer bodyContainer) {
        int i;
        XWPFParagraph startParagraph = (XWPFParagraph)iterableTemplate.getStartRun().getParent();
        XWPFParagraph endParagraph = (XWPFParagraph)iterableTemplate.getEndRun().getParent();
        int startPos = bodyContainer.getPosOfParagraphCTP(startParagraph.getCTP());
        int endPos = bodyContainer.getPosOfParagraphCTP(endParagraph.getCTP());
        for (int i2 = endPos - 1; i2 > startPos; --i2) {
            bodyContainer.removeBodyElement(i2);
        }
        XWPFParagraphWrapper startParagraphWrapper = new XWPFParagraphWrapper(startParagraph);
        XWPFParagraphWrapper endParagraphWrapper = new XWPFParagraphWrapper(endParagraph);
        Integer startRunPos = iterableTemplate.getStartMark().getRunPos();
        Integer endRunPos = iterableTemplate.getEndMark().getRunPos();
        List startRuns = startParagraph.getRuns();
        int startSize = startRuns.size();
        for (i = startSize - 1; i > startRunPos; --i) {
            startParagraphWrapper.removeRun(i);
        }
        for (i = endRunPos - 1; i >= 0; --i) {
            endParagraphWrapper.removeRun(i);
        }
    }

    @Override
    protected void handleIterable(IterableTemplate iterableTemplate, BodyContainer bodyContainer, Iterable<?> compute) {
        CTP startCtp = ((XWPFParagraph)iterableTemplate.getStartRun().getParent()).getCTP();
        CTP endCtp = ((XWPFParagraph)iterableTemplate.getEndRun().getParent()).getCTP();
        int startPos = bodyContainer.getPosOfParagraphCTP(startCtp);
        int endPos = bodyContainer.getPosOfParagraphCTP(endCtp);
        NumberingContinue numbringContinue = NumberingContinue.of(bodyContainer, startPos, endPos, iterableTemplate);
        IterableContext context = new IterableContext(startPos, endPos, numbringContinue);
        this.foreach(iterableTemplate, bodyContainer, context, compute.iterator());
        for (int i = endPos - 1; i > startPos; --i) {
            bodyContainer.removeBodyElement(i);
        }
    }

    @Override
    public void next(IterableTemplate iterable, ParentContext parentContext, IterableContext context, Object model) {
        BodyContainer bodyContainer = (BodyContainer)parentContext;
        XWPFParagraph endParagraph = (XWPFParagraph)iterable.getEndRun().getParent();
        CTP endCtp = endParagraph.getCTP();
        int start = context.getStart();
        int end = context.getEnd();
        context.getNumberingContinue().resetCache();
        XmlCursor insertPostionCursor = endCtp.newCursor();
        List<IBodyElement> bodyElements = bodyContainer.getBodyElements();
        ArrayList<IBodyElement> copies = new ArrayList<IBodyElement>();
        for (int i = start + 1; i < end; ++i) {
            XWPFParagraph copy;
            XmlObject object;
            IBodyElement iBodyElement = bodyElements.get(i);
            if (iBodyElement.getElementType() == BodyElementType.PARAGRAPH) {
                insertPostionCursor = endCtp.newCursor();
                XWPFParagraph insertNewParagraph = bodyContainer.insertNewParagraph(insertPostionCursor);
                int paraPos = bodyContainer.getParaPos(insertNewParagraph);
                bodyContainer.setParagraph((XWPFParagraph)iBodyElement, paraPos);
                insertPostionCursor = endCtp.newCursor();
                insertPostionCursor.toPrevSibling();
                object = insertPostionCursor.getObject();
                copy = new XWPFParagraph((CTP)object, bodyContainer.getTarget());
                DrawingSupport.updateDocPrId(copy);
                context.getNumberingContinue().updateNumbering((XWPFParagraph)iBodyElement, copy);
                copies.add((IBodyElement)copy);
                bodyContainer.updateBodyElements((IBodyElement)insertNewParagraph, (IBodyElement)copy);
                bodyContainer.setParagraph(copy, paraPos);
                continue;
            }
            if (iBodyElement.getElementType() != BodyElementType.TABLE) continue;
            insertPostionCursor = endCtp.newCursor();
            XWPFTable insertNewTbl = bodyContainer.insertNewTbl(insertPostionCursor);
            int tablePos = bodyContainer.getTablePos(insertNewTbl);
            bodyContainer.setTable(tablePos, (XWPFTable)iBodyElement);
            insertPostionCursor = endCtp.newCursor();
            insertPostionCursor.toPrevSibling();
            object = insertPostionCursor.getObject();
            copy = new XWPFTable((CTTbl)object, bodyContainer.getTarget());
            DrawingSupport.updateDocPrId((XWPFTable)copy);
            copies.add((IBodyElement)copy);
            bodyContainer.updateBodyElements((IBodyElement)insertNewTbl, (IBodyElement)copy);
            bodyContainer.setTable(tablePos, (XWPFTable)copy);
        }
        List<MetaTemplate> templates = this.resolver.resolveBodyElements(copies);
        this.process(templates, model);
    }
}

