/*
 * Decompiled with CFR 0.152.
 */
package com.ulisesbocchio.jasyptspringboot.aop;

import com.ulisesbocchio.jasyptspringboot.EncryptablePropertySourceConverter;
import com.ulisesbocchio.jasyptspringboot.configuration.EnvCopy;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.core.env.PropertySource;

public class EncryptableMutablePropertySourcesInterceptor
implements MethodInterceptor {
    private final EncryptablePropertySourceConverter propertyConverter;
    private final EnvCopy envCopy;

    public EncryptableMutablePropertySourcesInterceptor(EncryptablePropertySourceConverter propertyConverter, EnvCopy envCopy) {
        this.propertyConverter = propertyConverter;
        this.envCopy = envCopy;
    }

    private Object makeEncryptable(Object propertySource) {
        return this.propertyConverter.makeEncryptable((PropertySource)propertySource);
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        String method = invocation.getMethod().getName();
        Object[] arguments = invocation.getArguments();
        switch (method) {
            case "addFirst": {
                this.envCopy.addFirst((PropertySource)arguments[0]);
                return invocation.getMethod().invoke(invocation.getThis(), this.makeEncryptable(arguments[0]));
            }
            case "addLast": {
                this.envCopy.addLast((PropertySource)arguments[0]);
                return invocation.getMethod().invoke(invocation.getThis(), this.makeEncryptable(arguments[0]));
            }
            case "addBefore": {
                this.envCopy.addBefore((String)arguments[0], (PropertySource)arguments[1]);
                return invocation.getMethod().invoke(invocation.getThis(), arguments[0], this.makeEncryptable(arguments[1]));
            }
            case "addAfter": {
                this.envCopy.addAfter((String)arguments[0], (PropertySource)arguments[1]);
                return invocation.getMethod().invoke(invocation.getThis(), arguments[0], this.makeEncryptable(arguments[1]));
            }
            case "replace": {
                this.envCopy.replace((String)arguments[0], (PropertySource)arguments[1]);
                return invocation.getMethod().invoke(invocation.getThis(), arguments[0], this.makeEncryptable(arguments[1]));
            }
            case "remove": {
                this.envCopy.remove((String)arguments[0]);
                return invocation.proceed();
            }
        }
        return invocation.proceed();
    }
}

