/*
 * Decompiled with CFR 0.152.
 */
package com.ulisesbocchio.jasyptspringboot.environment;

import com.ulisesbocchio.jasyptspringboot.EncryptablePropertyDetector;
import com.ulisesbocchio.jasyptspringboot.EncryptablePropertyFilter;
import com.ulisesbocchio.jasyptspringboot.EncryptablePropertyResolver;
import com.ulisesbocchio.jasyptspringboot.InterceptionMode;
import com.ulisesbocchio.jasyptspringboot.environment.EncryptableEnvironment;
import com.ulisesbocchio.jasyptspringboot.environment.EnvironmentInitializer;
import com.ulisesbocchio.jasyptspringboot.environment.MutableConfigurablePropertyResolver;
import java.util.List;
import org.jasypt.encryption.StringEncryptor;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.ConfigurablePropertyResolver;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.web.context.support.StandardServletEnvironment;

public class StandardEncryptableServletEnvironment
extends StandardServletEnvironment
implements ConfigurableEnvironment,
EncryptableEnvironment {
    private MutablePropertySources encryptablePropertySources;
    private MutablePropertySources originalPropertySources;

    public StandardEncryptableServletEnvironment() {
        this(null, null, null, null, null, null, null);
    }

    public StandardEncryptableServletEnvironment(InterceptionMode interceptionMode, InterceptionMode propertySourcesInterceptionMode, List<Class<PropertySource<?>>> skipPropertySourceClasses, EncryptablePropertyResolver resolver, EncryptablePropertyFilter filter, StringEncryptor encryptor, EncryptablePropertyDetector detector) {
        EnvironmentInitializer initializer = new EnvironmentInitializer(interceptionMode, propertySourcesInterceptionMode, skipPropertySourceClasses, resolver, filter, encryptor, detector);
        initializer.initialize(this);
    }

    protected void customizePropertySources(MutablePropertySources propertySources) {
        super.customizePropertySources(propertySources);
    }

    public MutablePropertySources getPropertySources() {
        return this.encryptablePropertySources;
    }

    @Override
    public MutablePropertySources getOriginalPropertySources() {
        return super.getPropertySources();
    }

    @Override
    public void setEncryptablePropertySources(MutablePropertySources propertySources) {
        this.encryptablePropertySources = propertySources;
        ((MutableConfigurablePropertyResolver)this.getPropertyResolver()).setPropertySources(propertySources);
    }

    protected ConfigurablePropertyResolver createPropertyResolver(MutablePropertySources propertySources) {
        return EnvironmentInitializer.createPropertyResolver(propertySources);
    }

    public static StandardEncryptableServletEnvironmentBuilder builder() {
        return new StandardEncryptableServletEnvironmentBuilder();
    }

    public static class StandardEncryptableServletEnvironmentBuilder {
        private InterceptionMode interceptionMode;
        private InterceptionMode propertySourcesInterceptionMode;
        private List<Class<PropertySource<?>>> skipPropertySourceClasses;
        private EncryptablePropertyResolver resolver;
        private EncryptablePropertyFilter filter;
        private StringEncryptor encryptor;
        private EncryptablePropertyDetector detector;

        StandardEncryptableServletEnvironmentBuilder() {
        }

        public StandardEncryptableServletEnvironmentBuilder interceptionMode(InterceptionMode interceptionMode) {
            this.interceptionMode = interceptionMode;
            return this;
        }

        public StandardEncryptableServletEnvironmentBuilder propertySourcesInterceptionMode(InterceptionMode propertySourcesInterceptionMode) {
            this.propertySourcesInterceptionMode = propertySourcesInterceptionMode;
            return this;
        }

        public StandardEncryptableServletEnvironmentBuilder skipPropertySourceClasses(List<Class<PropertySource<?>>> skipPropertySourceClasses) {
            this.skipPropertySourceClasses = skipPropertySourceClasses;
            return this;
        }

        public StandardEncryptableServletEnvironmentBuilder resolver(EncryptablePropertyResolver resolver) {
            this.resolver = resolver;
            return this;
        }

        public StandardEncryptableServletEnvironmentBuilder filter(EncryptablePropertyFilter filter) {
            this.filter = filter;
            return this;
        }

        public StandardEncryptableServletEnvironmentBuilder encryptor(StringEncryptor encryptor) {
            this.encryptor = encryptor;
            return this;
        }

        public StandardEncryptableServletEnvironmentBuilder detector(EncryptablePropertyDetector detector) {
            this.detector = detector;
            return this;
        }

        public StandardEncryptableServletEnvironment build() {
            return new StandardEncryptableServletEnvironment(this.interceptionMode, this.propertySourcesInterceptionMode, this.skipPropertySourceClasses, this.resolver, this.filter, this.encryptor, this.detector);
        }

        public String toString() {
            return "StandardEncryptableServletEnvironment.StandardEncryptableServletEnvironmentBuilder(interceptionMode=" + (Object)((Object)this.interceptionMode) + ", propertySourcesInterceptionMode=" + (Object)((Object)this.propertySourcesInterceptionMode) + ", skipPropertySourceClasses=" + this.skipPropertySourceClasses + ", resolver=" + this.resolver + ", filter=" + this.filter + ", encryptor=" + this.encryptor + ", detector=" + this.detector + ")";
        }
    }
}

