/*
 * Decompiled with CFR 0.152.
 */
package com.ulisesbocchio.jasyptspringboot.wrapper;

import com.ulisesbocchio.jasyptspringboot.EncryptablePropertySourceConverter;
import com.ulisesbocchio.jasyptspringboot.configuration.EnvCopy;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;

public class EncryptableMutablePropertySourcesWrapper
extends MutablePropertySources {
    private final EncryptablePropertySourceConverter propertyConverter;
    private final EnvCopy envCopy;

    public EncryptableMutablePropertySourcesWrapper(PropertySources propertySources, EncryptablePropertySourceConverter propertyConverter, EnvCopy envCopy) {
        this(propertyConverter, envCopy);
        for (PropertySource propertySource : propertySources) {
            super.addLast(propertySource);
        }
    }

    public EncryptableMutablePropertySourcesWrapper(EncryptablePropertySourceConverter propertyConverter, EnvCopy envCopy) {
        this.propertyConverter = propertyConverter;
        this.envCopy = envCopy;
    }

    private PropertySource<?> makeEncryptable(PropertySource<?> propertySource) {
        return this.propertyConverter.makeEncryptable(propertySource);
    }

    public void addFirst(PropertySource<?> propertySource) {
        this.envCopy.addFirst(propertySource);
        super.addFirst(this.makeEncryptable(propertySource));
    }

    public void addLast(PropertySource<?> propertySource) {
        this.envCopy.addLast(propertySource);
        super.addLast(this.makeEncryptable(propertySource));
    }

    public void addBefore(String relativePropertySourceName, PropertySource<?> propertySource) {
        this.envCopy.addBefore(relativePropertySourceName, propertySource);
        super.addBefore(relativePropertySourceName, this.makeEncryptable(propertySource));
    }

    public void addAfter(String relativePropertySourceName, PropertySource<?> propertySource) {
        this.envCopy.addAfter(relativePropertySourceName, propertySource);
        super.addAfter(relativePropertySourceName, this.makeEncryptable(propertySource));
    }

    public void replace(String name, PropertySource<?> propertySource) {
        this.envCopy.replace(name, propertySource);
        super.replace(name, this.makeEncryptable(propertySource));
    }

    public PropertySource<?> remove(String name) {
        this.envCopy.remove(name);
        return super.remove(name);
    }
}

